#!/usr/bin/python3
# -*- coding:utf-8 -*-
import re
import math
import time
import os
import glob

def get_info(text):
  head='T      S             Z                     X                     Y'
  tail='SOC stabilization of the ground state'
  data_content=re.findall(head+'(.*)'+tail,text,re.S)
  return data_content

def get_info_v2(text):
  head='ABSORPTION SPECTRUM VIA TRANSITION ELECTRIC DIPOLE MOMENTS\n'
  tail='         ABSORPTION SPECTRUM VIA TRANSITION VELOCITY DIPOLE MOMENTS\n'
  data_content=re.findall(head+'(.*)'+tail,text,re.S)
  return data_content

start = time.perf_counter()
path_vec = glob.glob(r'*.out')
for k in range(0,len(path_vec)):
    print("源文件：" + path_vec[k])
    portion = os.path.splitext(path_vec[k])	#将文件名拆成名字和后缀
    newname = os.path.join(portion[0] + '.txt') 
#    newname1 = os.path.join(portion[0] + '-raw.txt') 
    print("数据汇总：" + newname, end='')
    with open(path_vec[k], 'r') as f:
      text=f.read()
    content=get_info(text)
    str2 = ''.join(content)
 
#  输出原始SOC列表信息    
#    str2.split('\n')
#      with open(newname1,"w") as f:
#              f.write(str2+'\n')

    str1 = re.findall("[-+]?[0-9]*\.?[0-9]+",str2)
    str3=[]
    for x in range(0,len(str1),8):
        i=str1[x]
        j=str1[x+1]
        b = 0
        for c in range(6):
          a = float (str1[x+c+2])
          b = a*a+b
        g ='{:.4f}'.format(math.sqrt(b))
        str4=[i,j,g]
        str3.append(str4)
    with open(newname,"w") as f:
      f.write("T, S, SOC\n")
      for i in str3:
        f.write(', '.join(i)+'\n')
        
# 输出跃迁能级信息
    content_ev=get_info_v2(text)
    str_ev = ''.join(content_ev)
    newname_ev = os.path.join(portion[0] + '-trans.txt')
    with open(newname_ev,"w") as f:
          f.write('ABSORPTION SPECTRUM VIA TRANSITION ELECTRIC DIPOLE MOMENTS\n'\
          + str_ev)
    print(', ' + newname_ev)

end = time.perf_counter()
time = '{:,.3f}'.format(end-start)
print ("elapsed time(s):"+ str(time))
